-- MySQL Administrator dump 1.4
--
-- ------------------------------------------------------
-- Server version	5.5.16


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;


--
-- Create schema cmx_dbexample
--

CREATE DATABASE IF NOT EXISTS cmx_dbexample;
USE cmx_dbexample;

--
-- Definition of table `linkevent`
--

DROP TABLE IF EXISTS `linkevent`;
CREATE TABLE `linkevent` (
  `linkeventID` bigint(20) NOT NULL DEFAULT '0',
  `networkid` bigint(20) DEFAULT NULL,
  `LinkeventDate` datetime DEFAULT NULL,
  `Subject` text,
  `Content` text,
  `Detail1` varchar(255) DEFAULT '',
  `Detail2` varchar(255) DEFAULT '',
  `Detail3` varchar(255) DEFAULT '',
  `Detail4` varchar(255) DEFAULT '',
  `Detail5` varchar(255) DEFAULT '',
  PRIMARY KEY (`linkeventID`),
  KEY `DiscourseID` (`networkid`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `linkevent`
--

/*!40000 ALTER TABLE `linkevent` DISABLE KEYS */;
INSERT INTO `linkevent` (`linkeventID`,`networkid`,`LinkeventDate`,`Subject`,`Content`,`Detail1`,`Detail2`,`Detail3`,`Detail4`,`Detail5`) VALUES 
 (1,1,'2005-01-04 00:00:00','Interaction Subject Description 1','Content keywords or text of this interaction','type1','null','null','null','null'),
 (2,1,'2005-01-05 01:00:00','Interaction Subject Description 2','Other content keywords or text','type1','null','null','null','null'),
 (3,1,'2005-01-06 11:00:00','Interaction Subject Description 3','Other content keywords or text','type1','null','null','null','null'),
 (4,1,'2005-01-06 22:00:00','Another interaction subject','Still more content description or special !codes','type2','null','null','null','null');
/*!40000 ALTER TABLE `linkevent` ENABLE KEYS */;


--
-- Definition of table `linkeventdetailconfig`
--

DROP TABLE IF EXISTS `linkeventdetailconfig`;
CREATE TABLE `linkeventdetailconfig` (
  `detail` int(10) unsigned NOT NULL,
  `label` varchar(45) NOT NULL,
  `description` varchar(45) NOT NULL,
  `isReadOnly` tinyint(1) NOT NULL,
  `networkid` int(11) DEFAULT NULL,
  `isSize` tinyint(1) NOT NULL,
  `isColor` tinyint(1) NOT NULL,
  `isNumeric` tinyint(1) NOT NULL,
  PRIMARY KEY (`detail`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `linkeventdetailconfig`
--

/*!40000 ALTER TABLE `linkeventdetailconfig` DISABLE KEYS */;
INSERT INTO `linkeventdetailconfig` (`detail`,`label`,`description`,`isReadOnly`,`networkid`,`isSize`,`isColor`,`isNumeric`) VALUES 
 (1,'type','the type of the linking event',1,1,1,1,1);
/*!40000 ALTER TABLE `linkeventdetailconfig` ENABLE KEYS */;


--
-- Definition of table `linkeventparent`
--

DROP TABLE IF EXISTS `linkeventparent`;
CREATE TABLE `linkeventparent` (
  `linkeventID` bigint(20) NOT NULL DEFAULT '0',
  `parentLinkeventID` bigint(20) NOT NULL DEFAULT '0',
  `networkid` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`linkeventID`,`parentLinkeventID`),
  KEY `DiscourseID` (`networkid`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `linkeventparent`
--

/*!40000 ALTER TABLE `linkeventparent` DISABLE KEYS */;
/*!40000 ALTER TABLE `linkeventparent` ENABLE KEYS */;


--
-- Definition of table `linkeventrecipient`
--

DROP TABLE IF EXISTS `linkeventrecipient`;
CREATE TABLE `linkeventrecipient` (
  `linkeventID` bigint(20) NOT NULL DEFAULT '0',
  `recipientNodeID` bigint(20) NOT NULL DEFAULT '0',
  `networkID` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`linkeventID`,`recipientNodeID`),
  KEY `DiscourseID` (`networkID`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `linkeventrecipient`
--

/*!40000 ALTER TABLE `linkeventrecipient` DISABLE KEYS */;
INSERT INTO `linkeventrecipient` (`linkeventID`,`recipientNodeID`,`networkID`) VALUES 
 (1,2,1),
 (2,3,1),
 (3,4,1),
 (1,4,1);
/*!40000 ALTER TABLE `linkeventrecipient` ENABLE KEYS */;


--
-- Definition of table `linkeventsender`
--

DROP TABLE IF EXISTS `linkeventsender`;
CREATE TABLE `linkeventsender` (
  `linkeventID` bigint(20) NOT NULL DEFAULT '0',
  `senderNodeID` bigint(20) NOT NULL DEFAULT '0',
  `networkid` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`linkeventID`,`senderNodeID`),
  KEY `DiscourseID` (`networkid`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `linkeventsender`
--

/*!40000 ALTER TABLE `linkeventsender` DISABLE KEYS */;
INSERT INTO `linkeventsender` (`linkeventID`,`senderNodeID`,`networkid`) VALUES 
 (1,1,1),
 (2,2,1),
 (3,3,1),
 (4,4,1);
/*!40000 ALTER TABLE `linkeventsender` ENABLE KEYS */;


--
-- Definition of table `network`
--

DROP TABLE IF EXISTS `network`;
CREATE TABLE `network` (
  `networkid` bigint(20) NOT NULL DEFAULT '0',
  `ElementTypeID` tinyint(4) NOT NULL DEFAULT '0',
  `Name` varchar(63) NOT NULL DEFAULT '',
  `Detail1` varchar(255) DEFAULT '',
  `Detail2` varchar(255) DEFAULT '',
  `Detail3` varchar(255) DEFAULT '',
  `Detail4` varchar(255) DEFAULT '',
  `Detail5` varchar(255) DEFAULT '',
  PRIMARY KEY (`networkid`)
) ENGINE=MyISAM AUTO_INCREMENT=152 DEFAULT CHARSET=latin1;

--
-- Dumping data for table `network`
--

/*!40000 ALTER TABLE `network` DISABLE KEYS */;
INSERT INTO `network` (`networkid`,`ElementTypeID`,`Name`,`Detail1`,`Detail2`,`Detail3`,`Detail4`,`Detail5`) VALUES 
 (1,0,'YOUR_NETWORK_NAME','YOUR_NETWORK_DESCRIPTION',NULL,NULL,NULL,NULL);
/*!40000 ALTER TABLE `network` ENABLE KEYS */;


--
-- Definition of table `networkdetailconfig`
--

DROP TABLE IF EXISTS `networkdetailconfig`;
CREATE TABLE `networkdetailconfig` (
  `detail` int(10) unsigned NOT NULL,
  `label` varchar(45) NOT NULL,
  `description` varchar(45) NOT NULL,
  `isReadOnly` tinyint(1) NOT NULL,
  `networkid` int(11) DEFAULT NULL,
  `isSize` tinyint(1) NOT NULL,
  `isColor` tinyint(1) NOT NULL,
  `isNumeric` tinyint(1) NOT NULL,
  PRIMARY KEY (`detail`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `networkdetailconfig`
--

/*!40000 ALTER TABLE `networkdetailconfig` DISABLE KEYS */;
INSERT INTO `networkdetailconfig` (`detail`,`label`,`description`,`isReadOnly`,`networkid`,`isSize`,`isColor`,`isNumeric`) VALUES 
 (1,'Description of Variable','Description about Variable Label',1,1,0,0,0);
/*!40000 ALTER TABLE `networkdetailconfig` ENABLE KEYS */;


--
-- Definition of table `node`
--

DROP TABLE IF EXISTS `node`;
CREATE TABLE `node` (
  `nodeID` bigint(20) NOT NULL DEFAULT '0',
  `networkid` bigint(20) DEFAULT NULL,
  `AliasID` bigint(20) DEFAULT '0',
  `Detail1` varchar(255) DEFAULT '',
  `Detail2` varchar(255) DEFAULT '',
  `Detail3` varchar(255) DEFAULT '',
  `Detail4` varchar(255) DEFAULT '',
  `Detail5` varchar(255) DEFAULT '',
  PRIMARY KEY (`nodeID`),
  KEY `DiscourseID` (`networkid`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `node`
--

/*!40000 ALTER TABLE `node` DISABLE KEYS */;
INSERT INTO `node` (`nodeID`,`networkid`,`AliasID`,`Detail1`,`Detail2`,`Detail3`,`Detail4`,`Detail5`) VALUES 
 (1,1,0,'Nodename1','Nodenickname1','null','null','null'),
 (2,1,0,'Nodename2','Nodenickname2','null','null','null'),
 (3,1,0,'Nodename3','Nodenickname3','null','null','null'),
 (4,1,0,'Nodename4','Nodenickname4','null','null','null');
/*!40000 ALTER TABLE `node` ENABLE KEYS */;


--
-- Definition of table `nodedetailconfig`
--

DROP TABLE IF EXISTS `nodedetailconfig`;
CREATE TABLE `nodedetailconfig` (
  `detail` int(10) unsigned NOT NULL,
  `label` varchar(45) NOT NULL,
  `description` varchar(45) NOT NULL,
  `isReadOnly` tinyint(1) NOT NULL DEFAULT '0',
  `isColor` tinyint(1) NOT NULL DEFAULT '0',
  `isSize` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'if 1 and isNumeric=1 detail can be used as size or ring property',
  `isNumeric` tinyint(1) NOT NULL DEFAULT '0',
  `networkid` int(11) NOT NULL,
  PRIMARY KEY (`detail`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 ROW_FORMAT=FIXED;

--
-- Dumping data for table `nodedetailconfig`
--

/*!40000 ALTER TABLE `nodedetailconfig` DISABLE KEYS */;
INSERT INTO `nodedetailconfig` (`detail`,`label`,`description`,`isReadOnly`,`isColor`,`isSize`,`isNumeric`,`networkid`) VALUES 
 (1,'Nodename','The unique name of the node',1,1,0,0,1),
 (2,'Nodenickname','The nickname used by the node',1,1,0,1,1);
/*!40000 ALTER TABLE `nodedetailconfig` ENABLE KEYS */;




/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
